<!DOCTYPE html>
<html lang="<?php echo get_cookie("lang"); ?>">
  <head>
    <!-- Required meta tags always come first -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo $SEO['title']; ?></title>
    <meta name="description" content="<?php echo ((strip_tags($SEO['description']))); ?>">
    <meta name="google-site-verification" content="<?php echo config_item("gwt"); ?>" />

     <?php

    if($SEO['meta'])
    {
    $image = false;
      foreach ($SEO['meta'] as $key => $value) {
        echo "<".$value['type']." ";
        foreach ($value['attr'] as $key => $value) {
          echo $key.'="'.$value.'" ';
          if($value == 'og:image')
            $image = true;
        }
        echo ">\n";
      }
    }
    echo $SEO['meta_raw'];
    ?>  
    <?php if(!$image){ ?>
     <meta property="og:image" content="<?php echo base_url(); ?>assets/images/facebook_banner.jpg">    
    <?php } ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css" />
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-alpha.4/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/style.css">
    
    
    <link rel="icon" type="image/png" href="<?php echo base_url(); ?>assets/images/favicon.png">
</head>
  <body>
    
    <?php echo $_NAVBAR; ?>

    <?php echo $_PAGE; ?>

    <?php echo $_FOOTER; ?>


    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/material-design-iconic-font/2.2.0/css/material-design-iconic-font.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css" />
    
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css" >
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css" />  
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqvmap/1.5.1/jqvmap.css" />

    



    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.0.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tether/1.2.0/js/tether.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-alpha.4/js/bootstrap.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/app.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jqvmap/1.5.1/jquery.vmap.min.js"  ></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jqvmap/1.5.1/maps/jquery.vmap.world.js"  ></script>      
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.4/jquery.lazy.min.js"  ></script>
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.4/jquery.lazy.plugins.min.js"  ></script>
                
    
    <?php if(config_item("gcaptcha_secret")){ ?>
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <?php } ?>

    <script>
    var base_url = '<?php echo base_url(); ?>';
     var csfrData = {};
     csfrData['<?php echo $this->security->get_csrf_token_name(); ?>'] = '<?php echo $this->security->get_csrf_hash(); ?>';
   </script>



   <div class="modal fade" id="mainModal">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">            
            <h4 class="modal-title"><i class="fa fa-spinner fa-pulse"></i> <?php echo __("Processing..."); ?></h4>

             <!--<div id="monitor">
                  <div class="scan">                
                  </div>
                <div class="glass">
                  <img src="#">
                </div>
              </div>-->

          </div>
          <div class="modal-body">

           

            <div class="text-muted process-msg"><?php echo __("Please wait..."); ?></div>
            <progress class="progress progress-success progress-sm process-value" value="0" max="100"></progress>
          </div>          
        </div><!-- /.modal-content -->
      </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->

  </body>
</html>